﻿using System;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Text.RegularExpressions;
using System.Web.Security.AntiXss;
using VIRP_WEB.BaseCode;
using VIRP.EFR.DAL;
using System.Collections.Generic;

namespace VIRP_WEB.Custom.EFR
{
    public partial class DoDFragmentRawData : EfrBasePage
    {
        protected readonly string PatientWorkflowsPage = "~/Custom/EFR/Patients/PatientWorkflows.aspx?patientId=";

        protected override void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                HiddenFieldPatientID.Value = AntiXssEncoder.HtmlEncode(Request.QueryString["patientId"], false);

                int patientId = Convert.ToInt32(HiddenFieldPatientID.Value);

                VIRP.CRS.BO.PATIENT p = VIRP.CRS.BLL.PATIENTManager.GetItem(CurrentUser, CurrentRegistryId, patientId);

                if (p != null)
                {
                    ReplacePageTitle("Patients > Patient Lookup > Workflows > Display Source DoD Fragment Data > " + p.FULL_NAME);
                }
                else
                {
                    ReplacePageTitle("Patients > Patient Lookup > Workflows > Display Source DoD Fragment Data");
                }

                //DataTable filesList = GetDoDFragmentFiles(patientId);
                DoDFragmentDB manager = new DoDFragmentDB();
                IEnumerable<usp_EFR_GetDoDFragmentFilesByPatientIdResult> filesList = manager.SelectDoDFragmentsRawDataByPatientId(patientId, "", 0, int.MaxValue);

                GridViewEFRFragmentsRawData.DataSource = filesList;
                GridViewEFRFragmentsRawData.DataBind();
            }

            // Added for 508 compliance with GridView column headers and footer
            Page.ClientScript.RegisterStartupScript(GetType(), "UpdateGridView", "UpdateGridView('" + GridViewEFRFragmentsRawData.ClientID + "');", true);
        }

        //public DataTable GetDoDFragmentFiles(int patientId)
        //{
        //    DataTable dataTable = new DataTable();

        //    try
        //    {
        //        DoDFragmentDB manager = new DoDFragmentDB();
                
        //        dataTable = SqlProvider.ExecuteSPDataTable(
        //            "RegistryConnectionString",
        //            "dbo.usp_EFR_GetDoDFragmentFilesByPatientId",
        //            new object[] { patientId
        //                //Session["ReportDoDFragment.sortColumn"].ToString(),
        //                //Session["ReportDoDFragment.sortOrder"].ToString(),
        //                //TextBoxSearchCriteria.Text.Trim()
        //            });
        //    }
        //    catch (Exception ex)
        //    {
        //        ServiceInterfaceManager.LogError("Error processing new referral: " + ex.ToString(), String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
        //    }

        //    return dataTable;
        //}

        public void FragmentsRawData_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            if (e.CommandName == "Details")
            {
                int index = Convert.ToInt32(e.CommandArgument);
                GridViewEFRFragmentsRawData.SelectedIndex = index;
                int id = Convert.ToInt32(GridViewEFRFragmentsRawData.SelectedValue);

                DoDFragmentDB manager = new DoDFragmentDB();
                DOD_FRAGMENT_RAW_DATA file = manager.SelectByRawDataId(id);

                Response.ContentType = "application/x-unknown";
                Response.AppendHeader("Content-Disposition", "attachment; filename=\"" + file.ORIGINAL_NAME + "\"");
                Response.BinaryWrite((byte[])file.FILE_DATA.ToArray());
            }
        }

        public string DisplayFormatDate(DateTime? date)
        {
            if (date.HasValue)
                return date.Value.ToString("d");
            else
                return "";
        }

        protected void ButtonBack_Click(object sender, EventArgs e)
        {
            ResponseRedirect(PatientWorkflowsPage, GetValidStringValue(HiddenFieldPatientID.Value));
        }

        private string GetValidStringValue(string pCurrentValue)
        {
            string currentValue = string.Empty;
            if (pCurrentValue != null)
            {
                if (Regex.IsMatch(pCurrentValue, "^[a-zA-Z0-9]*$"))
                {
                    currentValue = pCurrentValue;
                }
            }
            return currentValue;
        }

        private void ResponseRedirect(string destination, string queryString)
        {
            try
            {
                string queryStringValue = string.Empty;
                if (queryString != null)
                {
                    queryStringValue = AntiXssEncoder.UrlEncode(queryString);
                }

                string destinationUrl = string.Concat(destination, queryStringValue);
                string currentHost = Request.Url.Host;
                if (Helpers.IsDestinationUrlLocal(destinationUrl, currentHost))
                {
                    Server.Transfer(destinationUrl);
                }
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError("Failure in to redirect to: - PatientWorkflows page: " + ex.ToString(), String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
            }
        }
    }
}
